<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
if ($_REQUEST['action'] == 'region' OR empty($_REQUEST['action']))
{
	$signaturestyles 	= array();
	foreach ((array)VBSIGNATURES::$cache['signaturestyle'] as $signaturestyleid => $signaturestyle)
	{
		if (!$signaturestyle['active'])
		{
			// Inactive style
			continue;
		}
		
		// Index by styleid
		$signaturestyles[$signaturestyleid] = $signaturestyle['title'];
	}
	if (!count($signaturestyles))
	{
		// Missing categories
		print_stop_message('dbtech_vbsignatures_missing_x',
			$vbphrase['dbtech_vbsignatures_style'],
			$vbulletin->session->vars['sessionurl'],
			'signaturestyle',
			'modify'
		);
	}
	
	$fonts 	= array();
	foreach ((array)VBSIGNATURES::$cache['font'] as $fontid => $font)
	{
		if (!$font['active'])
		{
			// Inactive style
			continue;
		}
		
		// Index by styleid
		$fonts[$fontid] = $font['title'];
	}
	if (!count($fonts))
	{
		// Missing categories
		print_stop_message('dbtech_vbsignatures_missing_x',
			$vbphrase['dbtech_vbsignatures_font'],
			$vbulletin->session->vars['sessionurl'],
			'font',
			'modify'
		);
	}
	
	print_cp_header($vbphrase['dbtech_vbsignatures_region_management']);
	
	// Table header
	$headings = array();
	$headings[] = $vbphrase['title'];
	$headings[] = $vbphrase['text'];
	$headings[] = $vbphrase['active'];
	$headings[] = $vbphrase['edit'];
	$headings[] = $vbphrase['delete'];
	
	if (count(VBSIGNATURES::$cache['region']))
	{
		print_form_header('vbsignatures', 'region');
		construct_hidden_code('action', 'modify');
		print_table_header($vbphrase['dbtech_vbsignatures_region_management']);
		print_select_row($vbphrase['dbtech_vbsignatures_style'], 'signaturestyleid', $signaturestyles);
		print_submit_row($vbphrase['dbtech_vbsignatures_add_new_region'], false);
		
		print_table_start();
		print_table_header($vbphrase['dbtech_vbsignatures_region_management'], count($headings));
		print_description_row($vbphrase['dbtech_vbsignatures_region_management_descr'], false, count($headings));	
		print_cells_row($headings, 0, 'thead');
		
		foreach ((array)VBSIGNATURES::$cache['region'] as $regionid => $region)
		{
			// Table data
			$cell = array();
			$cell[] = htmlspecialchars_uni($region['title']);
			$cell[] = htmlspecialchars_uni($region['regiontext']);
			$cell[] = ($region['active'] ? $vbphrase['yes'] : '<span class="col-i"><strong>' . $vbphrase['no'] . '</strong></span>');
			$cell[] = construct_link_code($vbphrase['edit'], 'vbsignatures.php?' . $vbulletin->session->vars['sessionurl'] . 'do=region&amp;action=modify&amp;regionid=' . $regionid);
			$cell[] = construct_link_code($vbphrase['delete'], 'vbsignatures.php?' . $vbulletin->session->vars['sessionurl'] . 'do=region&amp;action=delete&amp;regionid=' . $regionid);
			
			// Print the data
			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
			
			if (!$region['active'])
			{
				// Move on
				continue;
			}
			
			foreach ($region as $key => $val)
			{
				// Store this as a hidden code
				construct_hidden_code('region[' . $key. '][' . $regionid. ']', $val);
			}
			
		}
		print_description_row($vbphrase['dbtech_vbsignatures_preview_settings'], false, count($headings), 'optiontitle');		
		print_description_row('<div style="position:relative;"><img src="' . $vbulletin->options['bburl'] . '/dbtech/vbsignatures/images/signatures/sample_' . $region['signaturestyleid'] . '.png" alt="" name="sample" data-clickable="0" data-styleid="' . $region['signaturestyleid'] . '" /></div>', false, count($headings));		
		echo '<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/' . VBSIGNATURES::$jQueryVersion . '/jquery.min.js"></script>';
		VBSIGNATURES::js('_region');
		print_table_footer(count($headings), "<input type=\"button\" id=\"preview\" class=\"button\" value=\"" . str_pad($vbphrase['dbtech_vbsignatures_preview_region'], 8, ' ', STR_PAD_BOTH) . "\" tabindex=\"1\" name=\"preview\" />");	
	}
	else
	{
		print_form_header('vbsignatures', 'region');	
		construct_hidden_code('action', 'modify');
		print_table_header($vbphrase['dbtech_vbsignatures_region_management']);
		print_description_row($vbphrase['dbtech_vbsignatures_no_regions']);
		print_select_row($vbphrase['dbtech_vbsignatures_style'], 'signaturestyleid', $signaturestyles);		
		print_submit_row($vbphrase['dbtech_vbsignatures_add_new_region'], false);	
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'modify')
{
	$regionid = $vbulletin->input->clean_gpc('r', 'regionid', TYPE_UINT);
	$region = ($regionid ? VBSIGNATURES::$cache['region'][$regionid] : false);
	
	if (!is_array($region))
	{
		// Non-existing region
		$regionid = 0;
		
		$signaturestyleid = $vbulletin->input->clean_gpc('r', 'signaturestyleid', TYPE_UINT);
		$signaturestyle = ($signaturestyleid ? VBSIGNATURES::$cache['signaturestyle'][$signaturestyleid] : false);
		if (!is_array($signaturestyle))
		{
			print_stop_message('dbtech_vbsignatures_missing_x',
				$vbphrase['dbtech_vbsignatures_style'],
				$vbulletin->session->vars['sessionurl'],
				'region',
				'region'
			);
		}
		
		// Set this
		$region['signaturestyleid'] = $signaturestyleid;
	}
	
	$fonts 	= array();
	foreach ((array)VBSIGNATURES::$cache['font'] as $fontid => $font)
	{
		if (!$font['active'])
		{
			// Inactive style
			continue;
		}
		
		// Index by styleid
		$fonts[$fontid] = $font['title'];
	}
	if (!count($fonts))
	{
		// Missing categories
		print_stop_message('dbtech_vbsignatures_missing_x',
			$vbphrase['dbtech_vbsignatures_font'],
			$vbulletin->session->vars['sessionurl'],
			'font',
			'modify'
		);
	}
	
	$defaults = array(
		'title' 			=> 'Example Region 1',
		'active' 			=> 1,
		'stringlength' 		=> 100,
		'fontcolor' 		=> '#FFFFFF',
		'fontsize' 			=> (VBSIGNATURES::$useTtf ? 12 : 3),
		'regiontext' 		=> 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin convallis hendrerit dui, et porttitor enim.',
		'signaturestyleid' 	=> $signaturestyleid,
	);
	
	$sizes = array(
		1 => 1,
		2 => 2,
		3 => 3,
		4 => 4,
		5 => 5,
	);
	
	$weights = array(
		0 => $vbphrase['none'],
		1 => $vbphrase['dbtech_vbsignatures_bold'],
		2 => $vbphrase['dbtech_vbsignatures_italic'],
		3 => $vbphrase['dbtech_vbsignatures_bold_italic'],
	);
	
	if (!file_exists($vbulletin->options['bburl'] . '/dbtech/vbsignatures/images/signatures/sample_' . $region['signaturestyleid'] . '.png'))
	{
		$parts = array();
		foreach ((array)VBSIGNATURES::$cache['part'] as $partid => $part)
		{
			if (!$part['active'])
			{
				// Inactive part
				continue;
			}
			
			if ($part['signaturestyleid'] != $region['signaturestyleid'])
			{
				// Wrong style
				continue;
			}
			
			if (!$layer = VBSIGNATURES::$cache['layer'][$part['layerid']])
			{
				// Nonexistant layer
				continue;
			}
			
			if (!$layer['active'])
			{
				// Inactive layer
				continue;
			}
			
			if (isset($parts[$layer['folder']]))
			{
				// Already had this folder
				continue;
			}
			
			// Index by folder
			$parts[$layer['folder']] = $partid;
		}
		
		if (!count($parts))
		{
			print_stop_message('dbtech_vbsignatures_missing_x',
				$vbphrase['dbtech_vbsignatures_part'],
				$vbulletin->session->vars['sessionurl'],
				'parts',
				'parts'
			);
		}
		
		// Create the new preview image
		VBSIGNATURES::createImage($parts, array(), 'sample_' . $region['signaturestyleid']);		
	}	
	
	if ($regionid)
	{
		// Edit
		print_cp_header(strip_tags(construct_phrase($vbphrase['dbtech_vbsignatures_editing_x_y'], $vbphrase['dbtech_vbsignatures_region'], $region['title'])));
		print_form_header('vbsignatures', 'region');
		construct_hidden_code('action', 'update');
		construct_hidden_code('regionid', $regionid);
		print_table_header(construct_phrase($vbphrase['dbtech_vbsignatures_editing_x_y'], $vbphrase['dbtech_vbsignatures_region'], $region['title']));
	}
	else
	{
		// Add
		print_cp_header($vbphrase['dbtech_vbsignatures_add_new_region']);
		print_form_header('vbsignatures', 'region');
		construct_hidden_code('action', 'update');
		construct_hidden_code('region[signaturestyleid]', $signaturestyleid);
		print_table_header($vbphrase['dbtech_vbsignatures_add_new_region']);
		
		// Start with the default data
		$region = $defaults;
	}
	
	if (VBSIGNATURES::$useTtf)
	{
		// Overwrite phrases with TTF-compliant ones
		$vbphrase['dbtech_vbsignatures_region_x'] = $vbphrase['dbtech_vbsignatures_region_x_ttf'];
		$vbphrase['dbtech_vbsignatures_region_y'] = $vbphrase['dbtech_vbsignatures_region_y_ttf'];
	}
	
	print_description_row($vbphrase['dbtech_vbsignatures_main_settings'], false, 2, 'optiontitle');	
	print_input_row($vbphrase['title'], 			'region[title]', 										$region['title']);
	print_yes_no_row($vbphrase['active'],			'region[active]',										$region['active']);
	print_description_row($vbphrase['dbtech_vbsignatures_image_settings'], false, 2, 'optiontitle');
	print_description_row($vbphrase['dbtech_vbsignatures_click_image_to_set_region'] . '<br />
		<div style="position:relative;"><img src="' . $vbulletin->options['bburl'] . '/dbtech/vbsignatures/images/signatures/sample_' . $region['signaturestyleid'] . '.png" alt="' . $vbphrase['dbtech_vbsignatures_click_image_to_set_region'] . '" name="sample" data-clickable="1" data-styleid="' . $region['signaturestyleid'] . '" style="cursor:pointer;" /></div>
	');
	print_input_row($vbphrase['dbtech_vbsignatures_region_x'], 			'region[xcoord]', 					$region['xcoord'], 			true, 4);
	print_input_row($vbphrase['dbtech_vbsignatures_region_y'], 			'region[ycoord]', 					$region['ycoord'], 			true, 4);
	print_input_row($vbphrase['dbtech_vbsignatures_string_length'], 	'region[stringlength]', 			$region['stringlength'], 	true, 4);
	print_input_row($vbphrase['dbtech_vbsignatures_font_color'], 		'region[fontcolor]', 				$region['fontcolor'], 		true, 8);
	if (VBSIGNATURES::$useTtf)
	{
		// We can use TrueType 
		print_select_row($vbphrase['dbtech_vbsignatures_font'], 		'region[fontid]', 		$fonts,		$region['fontid']);
		print_input_row($vbphrase['dbtech_vbsignatures_font_size'], 	'region[fontsize]', 				$region['fontsize'], 		true, 4);
		print_select_row($vbphrase['dbtech_vbsignatures_font_style'], 	'region[fontweight]', 	$weights,	$region['fontweight']);
	}
	else
	{
		// Normal text
		print_select_row($vbphrase['dbtech_vbsignatures_font_size'], 	'region[fontsize]', 	$sizes,		$region['fontsize']);
	}
	print_description_row($vbphrase['dbtech_vbsignatures_preview_settings'], false, 2, 'optiontitle');
	print_textarea_row($vbphrase['dbtech_vbsignatures_preview_text'], 	'region[regiontext]', 				$region['regiontext']);	
	echo '<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/' . VBSIGNATURES::$jQueryVersion . '/jquery.min.js"></script>';
	VBSIGNATURES::js('_region');
	print_submit_row(($regionid ? $vbphrase['save'] : $vbphrase['dbtech_vbsignatures_add_new_region']), false, 2, false, "<input type=\"button\" id=\"preview\" class=\"button\" value=\"" . str_pad($vbphrase['dbtech_vbsignatures_preview_region'], 8, ' ', STR_PAD_BOTH) . "\" tabindex=\"1\" name=\"preview\" />");
}

// #############################################################################
if ($_REQUEST['action'] == 'update')
{
	// Grab stuff
	$vbulletin->input->clean_array_gpc('p', array(
		'regionid' 	=> TYPE_UINT,
		'region' 		=> TYPE_ARRAY,
	));
	
	// init data manager
	$dm =& VBSIGNATURES::initDataManager('Region', $vbulletin, ERRTYPE_CP);
	
	// set existing info if this is an update
	if ($vbulletin->GPC['regionid'])
	{
		if (!$existing = VBSIGNATURES::$cache['region'][$vbulletin->GPC['regionid']])
		{
			// Couldn't find the region
			print_stop_message('dbtech_vbsignatures_invalid_x', $vbphrase['dbtech_vbsignatures_region'], $vbulletin->GPC['regionid']);
		}
		
		// Set existing
		$dm->set_existing($existing);
				
		// Added
		$phrase = $vbphrase['dbtech_vbsignatures_edited'];
	}
	else
	{
		// Added
		$phrase = $vbphrase['dbtech_vbsignatures_added'];
	}
	
	// region fields
	foreach ($vbulletin->GPC['region'] AS $key => $val)
	{
		if (!$vbulletin->GPC['regionid'] OR $existing[$key] != $val)
		{
			// Only set changed values
			$dm->set($key, $val);
		}
	}
	
	// Save! Hopefully.
	$dm->save();
		
	define('CP_REDIRECT', 'vbsignatures.php?do=region');
	print_stop_message('dbtech_vbsignatures_x_y', $vbphrase['dbtech_vbsignatures_region'], $phrase);
}

// #############################################################################
if ($_POST['action'] == 'displayorder')
{
	$vbulletin->input->clean_array_gpc('p', array('order' => TYPE_ARRAY));
	
	if (is_array($vbulletin->GPC['order']))
	{
		foreach ($vbulletin->GPC['order'] as $regionid => $displayorder)
		{
			if (!$existing = VBSIGNATURES::$cache['region'][$regionid])
			{
				// Couldn't find the region
				continue;
			}
			
			if ($existing['displayorder'] == $displayorder)
			{
				// No change
				continue;
			}
			
			// init data manager
			$dm =& VBSIGNATURES::initDataManager('Region', $vbulletin, ERRTYPE_CP);
				$dm->set_existing($existing);
				$dm->set('displayorder', $displayorder);
			$dm->save();
			unset($dm);	
		}
	}
	
	define('CP_REDIRECT', 'vbsignatures.php?do=region');
	print_stop_message('saved_display_order_successfully');	
}

// #############################################################################
if ($_REQUEST['action'] == 'delete')
{
	$vbulletin->input->clean_gpc('r', 'regionid', TYPE_UINT);
	
	print_cp_header(construct_phrase($vbphrase['dbtech_vbsignatures_delete_x'], $vbphrase['dbtech_vbsignatures_region']));
	print_delete_confirmation('dbtech_vbsignatures_region', $vbulletin->GPC['regionid'], 'vbsignatures', 'region', 'dbtech_vbsignatures_region', array('action' => 'kill'), '', 'title');
	print_cp_footer();
}

// #############################################################################
if ($_POST['action'] == 'kill')
{
	$vbulletin->input->clean_gpc('r', 'regionid', TYPE_UINT);
	
	if (!$existing = VBSIGNATURES::$cache['region'][$vbulletin->GPC['regionid']])
	{
		// Couldn't find the region
		print_stop_message('dbtech_vbsignatures_invalid_x', $vbphrase['dbtech_vbsignatures_region'], $vbulletin->GPC['regionid']);
	}
	
	// init data manager
	$dm =& VBSIGNATURES::initDataManager('Region', $vbulletin, ERRTYPE_CP);
		$dm->set_existing($existing);
	$dm->delete();
	
	define('CP_REDIRECT', 'vbsignatures.php?do=region');
	print_stop_message('dbtech_vbsignatures_x_y', $vbphrase['dbtech_vbsignatures_region'], $vbphrase['dbtech_vbsignatures_deleted']);	
}

print_cp_footer();

/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: region.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>